/* 
Veidotājs: Roberts Blite
Mērķis: Šis skripts dinamiski ielādē un atjauno lietotāja sveiciena ziņojumu galvenajā lapā.
Apraksts: Skripts veic AJAX pieprasījumu uz serveri (`main.php`), lai iegūtu lietotāja vārdu un uzvārdu, 
          un pēc tam atjaunina sveiciena tekstu HTML dokumentā.
*/

// Kad HTML dokuments ir pilnībā ielādēts, tiek veikts servera pieprasījums
document.addEventListener("DOMContentLoaded", () => {
    fetch('../php/main.php') // Veic GET pieprasījumu uz `main.php`
        .then(response => response.json()) // Pārveido atbildi JSON formātā
        .then(data => {
            if (data.success) {
                // Dinamiski atjauno sveiciena ziņojumu lapā, ja dati ir veiksmīgi saņemti
                document.getElementById('welcome-message').textContent =
                    `Laipni lūdzam, ${data.first_name} ${data.last_name}!`;
            } else {
                console.error(data.message); // Izvada kļūdas ziņojumu atkļūdošanai, ja pieprasījums neizdevās
            }
        })
        .catch(err => console.error("Neizdevās iegūt lietotāja datus:", err)); // Apstrādā kļūdas, ja pieprasījums neizdodas
});
